#set to zero as default, so not enforcing integral=1
RND<-function(data,date,into1=0,negtol=-0.001){

###################################################################################
#Section 2: load data
#OptionTau<-read.table("mydata.csv", sep=",")
#columns: date/ days to maturity/ call indicator/ strik K/ option price/ spot price/ VIX/ rf/ ImpVol
# interest rate is daily rate

# three dates to choose from 20081023, 20090618, 20130620

OptionTau<-data
DATE<-date
pos <- which(OptionTau[,1] %in% DATE)
OptionDateTau <- OptionTau[pos,] 
rf <- OptionDateTau[1,8]
st <- OptionDateTau[1,6] # spot price
tau <- OptionDateTau[1,2]



###################################################################################
#Section 3: data processing: find the at-the-money implied vol; transform the variables

# use Imp.Vol (of ATM option) as the Sigma
# Imp.Vol is the annual volatility
pos <- which( min(abs(OptionDateTau[,4] - st)) == abs(OptionDateTau[,4] - st)  )
ImpVol <- mean(OptionDateTau[pos,9])
Sigma <-  1*ImpVol*sqrt(1/365)

# using all calls and puts

# Call option 
pos <- which(OptionDateTau[,3] %in% 1)
CallOption <- OptionDateTau[pos,]
CallOption<-CallOption[order(CallOption[,4]),]

Kcall <- CallOption[,4]
Pcall <- CallOption[,5]
ncall <- length(Pcall)

# sort the call price
tempTrash <- sort(Kcall,index.return=T)
Kcall <- tempTrash$x
Pcall <- Pcall[tempTrash$ix]
rm(tempTrash)

# Put option 
pos <- which(OptionDateTau[,3] %in% 0)
PutOption <- OptionDateTau[pos,]
PutOption<-PutOption[order(PutOption[,4]),]

Kput <- PutOption[,4]                   
Pput <- PutOption[,5]

# sort the put price
tempTrash <- sort(Kput,index.return=T)
Kput <- tempTrash$x
Pput <- Pput[tempTrash$ix]
rm(tempTrash)

K <- append(Kcall, Kput)
P <- append(Pcall, Pput)

n <- length(K)
k <- (log(K/st) - rf*tau) / (Sigma*sqrt(tau))



###################################################################################
#Section 4: set key control parameters

# penalization methods, 1 (standard) or 2 (modified); see paper for details 
method<-1

#lower bound of degree of Hermite polynomial

degree1 <- ceiling(2*(n/log(n))^0.2)


######################################################################################
#Section 5: set other control parameters (less important)

# number of workers for computation
Ncore <- 1 # use >1 only on a cluster

# number of grid points for computing integrals
#m <- 1000    
m<-10000

# axis range for integration: 
minR <- -10
maxR <- 10

# x-axis on which hermite polys take values
x <- seq( minR, maxR, length.out=m)

# axis range for returns, for display purposes only
axisL2 = -0.9
axisR2 = 0.9



###################################################################################
#Section 6: select the penalization parameter using cross validation

# penalization parameter values to choose from, as input for cross validation
temp <- seq(0, 1e-4, length=25)
alphaR <- sort( c(temp, temp*10,temp*100, temp*1000 ) )
alphaR<-unique(alphaR)

# length of alpha vector
Num <- length(alphaR)

# number of folds for cross validation
nFold <- 10 

set.seed(0)



temp.ind<-1#C.result$ind[1]
bestAlphaR <-0# alphaR[temp.ind]

degreeVec<-c(degree1,degree1+1,degree1+2)


  J.result<-CV.j(nFold,n,ncall,P,k,tau,st,Sigma,degreeVec,x,Ncore,negtol)
  degree<-J.result$bestDegree



###################################################################################
#Section 7: carry out the estimation

# phi is the weighting function for Hermite functions
phi <- exp(-x^2 / 2)

# poly.list indicates which polynomials to use
poly.list <- hermite.h.polynomials( degree, normalized=F )    

# Tx is the matrix of basis functions 
# Ts is the orthonormal basis
Tx <- do.call(rbind, polynomial.values(poly.list, x))
Ts <- sweep(Tx, MARGIN=2, phi, '*')
for(i in 0:degree)
{
  Ts[i+1,] = (2^i * factorial(i) * sqrt(pi))^(-0.5) * Ts[i+1,]
}

# Compute the regressors for the linear regression

htemp <- x[2:length(x)]-x[1:(length(x)-1)]
ci <- 0.5*htemp[1:(length(htemp)-1)] + 0.5*htemp[2:length(htemp)]
ci <- c(htemp[1], ci, htemp[length(htemp)])
m <- length(ci)
rm(htemp)

# ci matrix
Ci <- matrix(rep(ci, n), nrow=n, byrow=TRUE)

# g is matrix of payoff
g <- matrix(rep(1, n*m),  nrow=n, byrow=TRUE)  

for (i in 1:n ) 
{
  if (i <= ncall) {
    temp <- st * ( exp(sqrt(tau)*Sigma*x) - 
                     exp(sqrt(tau)*Sigma*k[i]) )
  }
  else if (i > ncall) {
    temp <- st * ( exp(sqrt(tau)*Sigma*k[i]) - 
                     exp(sqrt(tau)*Sigma*x) )
  }
  temp[temp<0] = 0
  g[i,] <- temp
  rm(temp)
}


G <- g * Ci 

# R is the matrix of "regressors"
R = G %*% t(Ts)



# penalizaton matrix

chat <- 1/n * (t(R) %*% R)[1,1]
alpha <- bestAlphaR * chat * n^(1/3)

if (method==1){ 
  alphaI <- alpha * diag(degree+1)
  Fmat <- 2* ( t(R) %*% R + alphaI)
} else {
  tempMat <- t(R)%*%R 
  Vmat <- eigen(tempMat)$vectors   # eigen vecotr matrix
  Vlambda <- eigen(tempMat)$values # eigen values 
  
  # construct the Q-alpha diagonal matrix
  Dalpha <- diag( alpha - Vlambda )
  Dalpha[Dalpha<0] <- 0
  Qalpha <- Vmat %*% ( Dalpha %*% t(Vmat) )
  # quadratic coeff in the obj
  Fmat <- 2* ( t(R) %*% R + Qalpha)
}

#Estimate the coefficients

# linear coeff in the obj
f <- 2* (t(P) %*% R)

# equality constraints matrix
A1 <- ci %*% t(Ts)

# inequality constraints matrix
A2 <- t(Ts)

# combine into 1 matrix
if (into1==1){
  A <- rbind(A1, A2)
  A<-t(A)
  # specify the number of equalities
  neq <- 1
  b <- c( 1, rep(negtol,m) )
}else{
  A <- t(A2)
  neq <- 0
  b <- rep(negtol,m)
}

# solve
prob <- solve.QP(Fmat, f, A, b, neq)
beta <- prob$solution[1:(degree+1)]


PRED<-R%*%beta

return(list(x,beta,Ts,Sigma,PRED))

}







